/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.networking.messages;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.core.economy.networking.messages.Message;
import net.impactdev.impactor.core.economy.transactions.context.TransactionContext;
import net.impactdev.json.JObject;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;

public final class TransactionMessage
implements Message {
    public static final Key KEY = Key.key((String)"impactor:transaction/normal");
    private final UUID id;
    private final TransactionContext transaction;

    public TransactionMessage(UUID id, EconomyTransaction transaction) {
        this.id = id;
        this.transaction = TransactionContext.from(transaction);
    }

    private TransactionMessage(UUID id, TransactionContext transaction) {
        this.id = id;
        this.transaction = transaction;
    }

    @Override
    public Key key() {
        return KEY;
    }

    @Override
    @NotNull
    public UUID id() {
        return this.id;
    }

    public TransactionContext context() {
        return this.transaction;
    }

    @Override
    public JsonElement serialized() {
        JObject transaction = new JObject().add("currency", this.transaction.currency().key().asString()).add("account", this.transaction.account().toString()).add("amount", this.transaction.amount()).add("type", this.transaction.type().ordinal());
        JObject json = new JObject().add("id", this.id.toString()).add("key", this.key().asString()).add("transaction", transaction);
        return json.toJson();
    }

    public static TransactionMessage deserialize(UUID id, JsonElement json) {
        Objects.requireNonNull(json, "json");
        JsonObject content = json.getAsJsonObject();
        Currency currency = EconomyService.instance().currencies().currency(Key.key((String)content.get("currency").getAsString())).orElseThrow(() -> new IllegalStateException("Invalid currency: " + content.get("currency").getAsString()));
        UUID account = UUID.fromString(content.get("account").getAsString());
        BigDecimal amount = new BigDecimal(content.get("amount").getAsString());
        EconomyTransactionType type = EconomyTransactionType.valueOf(content.get("type").getAsString());
        return new TransactionMessage(id, new TransactionContext(currency, account, type, amount));
    }
}

